using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Controls_ZipCodeSelector :
System.Web.UI.UserControl, IZipCode
{
   private string zip = string.Empty;

   [Personalizable(PersonalizationScope.User)]
   [WebDisplayName("Kod pocztowy")]
   [WebDescription("Kod pocztowy dostpny dla poczonych kontrolek do prezentacji informacji lokalnych")]
   public string ZipCode
   {
      get { return zip; }
      set { zip = value; }
   }

   protected void Page_Load(object sender, EventArgs e)
   {

   }

   protected override void OnPreRender(EventArgs e)
   {
      base.OnPreRender(e);
      if (zip != null)
         txtZip.Text = zip;
   }

   [ConnectionProvider("Dostawca kodu pocztowego", "ZipCodeProvider")]
   public IZipCode ProvideIZipCode()
   {
      return this;
   }

   protected void btnSetZip_Click(object sender, EventArgs e)
   {
      zip = txtZip.Text;
      txtZip.Text = string.Empty;
   }
}
